# README – Base de datos de programas de desarrollo social del Visualizador de programas y acciones de desarrollo social

El presente archivo contiene información referente a programas en materia de desarrollo social en México.  
Su objetivo es poner a disposición de las personas usuarias una **base de datos homologada** que permita realizar **análisis comparativos**.  

Este README tiene como finalidad **documentar las características de las variables incluidas** y proporcionar **lineamientos básicos para la correcta interpretación de los datos**.

---

## Variable: Presupuesto 

### Descripción  
Monto asignado en millones de pesos a cada programa, según el archivo de origen.

### Tipo de dato  
Numérico.

---

## Valores faltantes

En algunas filas, la variable de presupuesto aparece con valor **NA (vacío)**.  
Los valores vacíos corresponden a “**No disponible**” en el archivo de origen.

Es importante distinguir entre:  
- **0 (cero):** el programa no contó con presupuesto asignado.  
- **NA:** no existe información disponible en la fuente original.

---

## Consideraciones para el análisis

- Los valores **NA deben tratarse como datos faltantes** y no como ceros.  
- Al realizar cálculos (sumas, promedios, etc.), se recomienda usar **funciones que contemplen la exclusión de NA**.  
- La ausencia de datos no implica necesariamente inexistencia de recursos, sino **limitación en la disponibilidad de información reportada**.

